﻿$(function(){
	// 加载查询列表
	creatGrid();
});
/**
 * easyUi dataGrid注册方式说明，防止二次渲染 class注册方式一般是为了初始化属性，js方式则属性和事件都可初始化
 * 但是不管是class方式还是js方式注册组件，每次注册，只要被设置过url属性就会做请求。
 * 所以在不可避免要使用js方式注册的情况下，索性就不要使用class方式注册了。
 */
function creatGrid() {
	$('#onlineUserList').datagrid({
		fit : true,// 设置为true时铺满它所在的容器.
		fitColumns : true,// 设置为true将自动使列适应表格宽度以防止出现水平滚动
		nowrap : false,// 设置为true，当数据长度超出列宽时将会自动截取。
		striped : true,// 设置为true将交替显示行背景。
		collapsible : true,// 定义是否显示可折叠按钮。
		singleSelect : false,// 设置为true将只允许选择一行。
		border : false,
		remoteSort : false,// 定义是否通过远程服务器对数据排序。
		pagination : true,// 分页组件是否显示
		pageNumber : 1,// 起始页
		pageSize : 10,// 每页显示的记录条数，默认为10
		pageList : [ 10, 20, 50 ],// 每页显示多少行
		rownumbers : true,// 行号
		url : 'listOnlineUser.html',
		toolbar : '#tbar',
		columns : [ [ {
			field : 'username',
			title : 'user name',
			width : 100,
			halign: 'center',
			align : 'left'
		}, {
			field : 'nickName',
			title : 'nick name',
			width : 100,
			halign: 'center',
			align : 'left'
		}, {
			field : 'realName',
			title : 'real name',
			width : 80,
			halign: 'center',
			align : 'left'
		}, {
			field : 'gender',
			title : 'gender',
			width : 40,
			halign: 'center',
			align : 'center'

		}, {
			field : 'regIp',
			title : 'registration IP',
			width : 100,
			halign: 'center',
			align : 'center'

		}, {
			field : 'lastLoginIp',
			title : 'logon IP',
			width : 100,
			halign: 'center',
			align : 'center'

		}, {
			field : 'loginCount',
			title : 'logon times',
			width : 50,
			halign: 'center',
			align : 'right'
		}, {
			field : 'manage',
			title : 'manage',
			halign: 'center',
			align : 'center',
			width : 100,
			formatter : operate
		} ] ],
		// 当数据载入成功时触发。
		onLoadSuccess : function(data) {
			$('.forced').linkbutton({
				iconCls : 'icon-edit',
				plain : true
			});
		}
	});
}
// 操作
function operate(value, rowData, rowIndex) {
	var userId = rowData.userId;
	return "<a href='javascript:forcedOffline("+userId+");' class='forced'>forced offline</a>";
}
//强制下线
function forcedOffline(userId){
	$.ajax({
		url:"forcedOffline.html",
		type: 'post',
		data:{"userId":userId,"msg":"forcedOffline"},
		dataType: 'json',
		success:function(data){
			if(data){
				alert("forced logout succeed!");
				reload();
			}else{
				alert("forced logout fail!");
			}
		}
	});
}
// 刷新
function reload() {
	$('#onlineUserList').datagrid('clearSelections');
	$('#onlineUserList').datagrid('reload');
}
//查询
function find(){
	var userName = $("#userName").val();
	$('#onlineUserList').datagrid('load', {
		userName : userName
	});
}